<?php
session_start();

// Verificar si el usuario está logueado y tiene permisos para ver esta página
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Conectar a la base de datos
require_once 'conexiones/conexion.php';

// Obtener los clientes registrados
$stmt = $pdo->prepare("SELECT id, dni, nombre, correo, telefono, direccion FROM clientes");
$stmt->execute();
$clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Procesar la acción de editar un cliente
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_client'])) {
    $cliente_id = $_POST['client_id'];
    $dni = $_POST['dni'];
    $nombre = $_POST['nombre'];
    $correo = $_POST['correo'];
    $telefono = $_POST['telefono'];
    $direccion = $_POST['direccion'];

    // Actualizar los datos del cliente
    $stmt = $pdo->prepare("UPDATE clientes SET dni = ?, nombre = ?, correo = ?, telefono = ?, direccion = ? WHERE id = ?");
    $stmt->execute([$dni, $nombre, $correo, $telefono, $direccion, $cliente_id]);

    header('Location: clientes.php');
    exit;
}

// Procesar la acción de eliminar un cliente
if (isset($_GET['delete'])) {
    $cliente_id = $_GET['delete'];

    // Eliminar el cliente de la base de datos
    $stmt = $pdo->prepare("DELETE FROM clientes WHERE id = ?");
    $stmt->execute([$cliente_id]);

    header('Location: clientes.php');
    exit;
}

// Procesar la acción de agregar un nuevo cliente
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_client'])) {
    $dni = $_POST['dni'];
    $nombre = $_POST['nombre'];
    $correo = $_POST['correo'];
    $telefono = $_POST['telefono'];
    $direccion = $_POST['direccion'];

    // Insertar el nuevo cliente en la base de datos
    $stmt = $pdo->prepare("INSERT INTO clientes (dni, nombre, correo, telefono, direccion) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$dni, $nombre, $correo, $telefono, $direccion]);

    header('Location: clientes.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Clientes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include "menuajuste.php"; ?>

    <div class="content">
        <h1 class="text-center mb-4">Gestión de Clientes</h1>

        <!-- Formulario para agregar nuevo cliente -->
        <div class="card mb-4">
            <div class="card-header">Agregar Nuevo Cliente</div>
            <div class="card-body">
                <form action="" method="POST">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="dni" class="form-label">DNI</label>
                            <input type="text" class="form-control" id="dni" name="dni" required>
                        </div>
                        <div class="col-md-6">
                            <label for="nombre" class="form-label">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" required>
                        </div>
                        <div class="col-md-6">
                            <label for="correo" class="form-label">Correo</label>
                            <input type="email" class="form-control" id="correo" name="correo" required>
                        </div>
                        <div class="col-md-6">
                            <label for="telefono" class="form-label">Teléfono</label>
                            <input type="text" class="form-control" id="telefono" name="telefono" required>
                        </div>
                        <div class="col-12">
                            <label for="direccion" class="form-label">Dirección</label>
                            <input type="text" class="form-control" id="direccion" name="direccion" required>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3" name="add_client">Agregar Cliente</button>
                </form>
            </div>
        </div>

        <!-- Tabla de clientes -->
        <div class="card">
            <div class="card-header">Clientes Registrados</div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>DNI</th>
                                <th>Nombre</th>
                                <th>Correo</th>
                                <th>Teléfono</th>
                                <th>Dirección</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($clientes as $cliente): ?>
                                <tr>
                                    <td><?= htmlspecialchars($cliente['dni']) ?></td>
                                    <td><?= htmlspecialchars($cliente['nombre']) ?></td>
                                    <td><?= htmlspecialchars($cliente['correo']) ?></td>
                                    <td><?= htmlspecialchars($cliente['telefono']) ?></td>
                                    <td><?= htmlspecialchars($cliente['direccion']) ?></td>
                                    <td>
                                        <button class="btn btn-warning btn-sm" onclick="openEditModal(<?= htmlspecialchars(json_encode($cliente)) ?>)">Editar</button>
                                        <button class="btn btn-danger btn-sm" onclick="openDeleteModal(<?= $cliente['id'] ?>)">Eliminar</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para Editar Cliente -->
    <div class="modal fade" id="editClientModal" tabindex="-1" aria-labelledby="editClientModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editClientForm" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editClientModalLabel">Editar Cliente</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="client_id" id="editClientId">
                        <div class="mb-3">
                            <label for="editDni" class="form-label">DNI</label>
                            <input type="text" class="form-control" id="editDni" name="dni" required>
                        </div>
                        <div class="mb-3">
                            <label for="editNombre" class="form-label">Nombre</label>
                            <input type="text" class="form-control" id="editNombre" name="nombre" required>
                        </div>
                        <div class="mb-3">
                            <label for="editCorreo" class="form-label">Correo</label>
                            <input type="email" class="form-control" id="editCorreo" name="correo" required>
                        </div>
                        <div class="mb-3">
                            <label for="editTelefono" class="form-label">Teléfono</label>
                            <input type="text" class="form-control" id="editTelefono" name="telefono" required>
                        </div>
                        <div class="mb-3">
                            <label for="editDireccion" class="form-label">Dirección</label>
                            <input type="text" class="form-control" id="editDireccion" name="direccion" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary" name="update_client">Guardar Cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal para Confirmar Eliminación -->
    <div class="modal fade" id="deleteClientModal" tabindex="-1" aria-labelledby="deleteClientModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="deleteClientForm" method="GET">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteClientModalLabel">Confirmar Eliminación</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>¿Estás seguro de que deseas eliminar este cliente?</p>
                        <input type="hidden" name="delete" id="deleteClientId">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Eliminar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Abrir el modal de edición con los datos del cliente
        function openEditModal(cliente) {
            document.getElementById('editClientId').value = cliente.id;
            document.getElementById('editDni').value = cliente.dni;
            document.getElementById('editNombre').value = cliente.nombre;
            document.getElementById('editCorreo').value = cliente.correo;
            document.getElementById('editTelefono').value = cliente.telefono;
            document.getElementById('editDireccion').value = cliente.direccion;
            new bootstrap.Modal(document.getElementById('editClientModal')).show();
        }

        // Abrir el modal de eliminación con el ID del cliente
        function openDeleteModal(clientId) {
            document.getElementById('deleteClientId').value = clientId;
            new bootstrap.Modal(document.getElementById('deleteClientModal')).show();
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
